<?php
/**
 * Additional Information tab
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/tabs/additional-information.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author        WooThemes
 * @package       WooCommerce/Templates
 * @version       3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $product;

$heading = esc_html( apply_filters( 'woocommerce_product_additional_information_heading', esc_html__( 'Additional information', 'seosight' ) ) );

?>

<?php if ( $heading ) : ?>
	<h4 class="h2 heading-title"><?php echo esc_html($heading); ?></h4>
	<div class="heading-line">
		<span class="short-line"></span>
		<span class="long-line"></span>
	</div>
<?php endif; ?>

<?php do_action( 'woocommerce_product_additional_information', $product ); ?>
